package com.slprojects.pizzeria;

import static com.slprojects.pizzeria.NumTable.numTable;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.util.ArrayList;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    private ArrayList<Button> boutons;
    private ArrayList<Integer> idIndexes;
    private ArrayList<Integer> numCommands;
    private ArrayList<String> nomBoutons;
    private int numTable;
    private backTasks tacheDeFond;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Log.i("onCreate", "MainActivity");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Intent intent = getIntent();

        // On récupère le num de la table
        numTable = intent.getIntExtra(NumTable.numTable, 1);
        TextView textView = findViewById(R.id.textNumTable);
        String numTableText = textView.getText().toString() + numTable;
        textView.setText(numTableText);
        Log.i("Numéro de la table", String.valueOf(numTable));
        // Fin avec le num de la table

        boutons = new ArrayList<>();
        idIndexes = new ArrayList<>();
        numCommands = new ArrayList<>();
        nomBoutons = new ArrayList<>();

        boutons.add(findViewById(R.id.napolitaine));
        boutons.add(findViewById(R.id.royale));
        boutons.add(findViewById(R.id.quatreFromages));
        boutons.add(findViewById(R.id.montagnarde));
        boutons.add(findViewById(R.id.raclette));
        boutons.add(findViewById(R.id.hawaii));
        boutons.add(findViewById(R.id.pannaCotta));
        boutons.add(findViewById(R.id.tiramisu));

        // On ajoute un listener sur chaque bouton
        boutons.forEach((btn) -> btn.setOnClickListener(this));

        // On ajoute l'id de chaque bouton (normalement dans l'ordre
        boutons.forEach((btn) -> idIndexes.add(btn.getId()));

        // Et on ajoute le nom de chaque bouton (également normalement dans l'ordre)
        boutons.forEach((btn) -> nomBoutons.add(btn.getText().toString()));

        // On regarde s'il y a déjà eu une instance
        if (savedInstanceState != null) {
            // On récupère le nombre de commandes
            numCommands = savedInstanceState.getIntegerArrayList("numCommands");
            // Et on remet le nom avec les num de commandes aux boutons
            boutons.forEach(this::setButtonText);
        }else{
            // On réserve les espaces pour les commandes
            boutons.forEach((btn) -> numCommands.add(idIndexes.indexOf(btn.getId()), 0));
        }
        tacheDeFond = new backTasks();
        tacheDeFond.execute();
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putIntegerArrayList("numCommands", numCommands);
    }

    public void onClick(View v) {
        try{
            Button bouton = boutons.get(idIndexes.indexOf(v.getId()));
            numCommands.set(idIndexes.indexOf(v.getId()), numCommands.get(idIndexes.indexOf(v.getId()))+1);
            setButtonText(bouton);

            // Envoie de la commande
            tacheDeFond.registerCommand(numTable+nomBoutons.get(idIndexes.indexOf(v.getId())));
        }catch ( Exception e ){
            Log.e("Erreur", e.getMessage());
        }
    }

    public void setButtonText(Button bouton){
        if(numCommands.get(idIndexes.indexOf(bouton.getId())) == 0){
            bouton.setText(nomBoutons.get(idIndexes.indexOf(bouton.getId())));
        }else{
            String titre = nomBoutons.get(idIndexes.indexOf(bouton.getId())) + " : " + numCommands.get(idIndexes.indexOf(bouton.getId()));
            bouton.setText(titre);
        }
    }
}