package com.slprojects.pizzeria;

import android.os.AsyncTask;
import android.util.Log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class backTasks extends AsyncTask {
    private Socket socket;
    private PrintWriter output;
    private BufferedReader input;

    @Override
    protected Object doInBackground(Object[] objects) {
        int serverPort = 9874;
        String address = "chadok.info";

        try {
            InetAddress ipAddress = InetAddress.getByName(address);
            Log.i("backTasks:", "Connecting to " + address + ":"+ serverPort + "...");
            socket = new Socket(ipAddress, serverPort);
            Log.i("backTasks:", "Connected");

            output = new PrintWriter(socket.getOutputStream(), true);
            input = new BufferedReader(new InputStreamReader(socket.getInputStream()));

            while(true){
                String message = input.readLine();
                if (message != null){
                    Log.i("backTasks", "received message: " + message);
                }
            }

        } catch (Exception x) {
            x.printStackTrace();
        }
        return null;
    }

    public void registerCommand(String command){
        if(output != null){
            Log.i("backTasks", "registered command: "+command);
            output.write(command);
        }

    }
}
