/*
 * Decompiled with CFR 0.152.
 */
package com.slprojects.slcraftplugin;

import com.slprojects.slcraftplugin.commandes.linkCodeCommand;
import com.slprojects.slcraftplugin.commandes.wildCommand;
import com.slprojects.slcraftplugin.tachesParalleles.internalWebServer;
import com.slprojects.slcraftplugin.tachesParalleles.savePlayerData;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.mariadb.jdbc.MariaDbPoolDataSource;

public final class Main
extends JavaPlugin
implements Listener {
    private List<UUID> wildCommandActiveUsers;
    private static FileConfiguration config;
    private savePlayerData savePlayerData;

    public void onEnable() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getServer().getConsoleSender().sendMessage("PlaceholderAPI charg\u00e9");
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        } else {
            this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "PlaceholderAPI n'est pas accessible!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        this.saveDefaultConfig();
        this.reloadConfig();
        config = this.getConfig();
        this.updateConfig();
        this.savePlayerData = new savePlayerData(this);
        this.initDatabase();
        this.wildCommandActiveUsers = new ArrayList<UUID>();
        wildCommand wildCommand2 = new wildCommand(this);
        Objects.requireNonNull(this.getCommand("wild")).setExecutor((CommandExecutor)wildCommand2);
        linkCodeCommand linkCodeCommand2 = new linkCodeCommand(this);
        Objects.requireNonNull(this.getCommand("getLinkCode")).setExecutor((CommandExecutor)linkCodeCommand2);
        internalWebServer.startServer(this);
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "SL-Craft | Plugin d\u00e9marr\u00e9");
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "SL-Craft | Plugin \u00e9teint");
        this.getServer().getOnlinePlayers().forEach(player -> this.savePlayerData.saveOnQuit((Player)player));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent e) {
        e.joinMessage(null);
        this.savePlayerData.saveOnJoin(e.getPlayer());
        String welcomeMessage = PlaceholderAPI.setPlaceholders((Player)e.getPlayer(), (String)Objects.requireNonNull(this.getConfig().getString("player-join-message")));
        for (Player p : this.getServer().getOnlinePlayers()) {
            p.sendMessage(welcomeMessage);
            if (!this.getConfig().getBoolean("player-join-playSound")) continue;
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 0.0f);
        }
        this.sendMessageToDiscord("**" + e.getPlayer().getName() + "** vient de rejoindre le serveur");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        e.quitMessage(null);
        this.savePlayerData.saveOnQuit(e.getPlayer());
        String quitMessage = PlaceholderAPI.setPlaceholders((Player)e.getPlayer(), (String)Objects.requireNonNull(this.getConfig().getString("player-quit-message")));
        for (Player p : this.getServer().getOnlinePlayers()) {
            p.sendMessage(quitMessage);
        }
        this.sendMessageToDiscord("**" + e.getPlayer().getName() + "** a quitt\u00e9 le serveur");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void AsyncChatEvent(AsyncPlayerChatEvent e) {
        Player gg = Bukkit.getPlayer((String)"gagafeee");
        String FinalMessage = e.getMessage();
        FinalMessage = Pattern.compile("\\*\\*\\*(.*?)\\*\\*\\*").matcher(FinalMessage).replaceAll("\u00a7l\u00a7o$1\u00a7r");
        FinalMessage = Pattern.compile("\\*\\*(.*?)\\*\\*").matcher(FinalMessage).replaceAll("\u00a7l$1\u00a7r");
        FinalMessage = Pattern.compile("\\*(.*?)\\*").matcher(FinalMessage).replaceAll("\u00a7o$1\u00a7r");
        FinalMessage = Pattern.compile("__(.*?)__").matcher(FinalMessage).replaceAll("\u00a7n$1\u00a7r");
        FinalMessage = Pattern.compile("~~(.*?)~~").matcher(FinalMessage).replaceAll("\u00a7m$1\u00a7r");
        this.sendMessageToDiscord(e.getMessage(), e.getPlayer().getName());
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(FinalMessage);
        }
        e.setCancelled(true);
    }

    public String getHttp(String urlString) {
        String returnData = "";
        try {
            String inputLine;
            URL url = new URL(urlString);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Accept-Language", "fr-FR,fr;q=0.5");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setAllowUserInteraction(false);
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            con.disconnect();
            returnData = response.toString();
        }
        catch (Exception ex) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Impossible de se connecter \u00e0 l'url " + urlString + ". Func getHttp(String urlString)");
            ex.printStackTrace();
        }
        return returnData;
    }

    public void sendMessageToDiscord(String message, String username) {
        message = message.replace("<@everyone>", "**everyone**");
        message = message.replace("<@here>", "**here**");
        message = message.replace("@everyone", "**everyone**");
        message = message.replace("@here", "**here**");
        JSONObject json = new JSONObject();
        json.put((Object)"message", (Object)message);
        json.put((Object)"username", (Object)username);
        try {
            String urlString = config.getString("discordBot-api-url") + "mc/chat/" + URLEncoder.encode(json.toJSONString(), "UTF-8").replace("+", "%20");
            String response = this.getHttp(urlString);
            if (this.getConfig().getBoolean("msg-verbose")) {
                this.getServer().getConsoleSender().sendMessage("Func AsyncChatEvent(PlayerChatEvent e), HTTP response:" + response);
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().warning(ChatColor.RED + "Impossible de d'encoder les donn\u00e9es. Func AsyncChatEvent(PlayerChatEvent e)");
            ex.printStackTrace();
        }
    }

    public void sendMessageToDiscord(String message) {
        this.sendMessageToDiscord(message, "SL-Craft");
    }

    public boolean checkActiveUserForWildCommand(UUID playerUuid) {
        if (this.wildCommandActiveUsers.contains(playerUuid)) {
            return false;
        }
        this.wildCommandActiveUsers.add(playerUuid);
        return true;
    }

    public void removeActiveUserForWildCommand(UUID playerUuid) {
        if (this.wildCommandActiveUsers.contains(playerUuid)) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.wildCommandActiveUsers.remove(playerUuid);
        }
    }

    public Connection bddOpenConn() {
        Connection conn = null;
        try {
            Class.forName("org.mariadb.jdbc.MariaDbPoolDataSource");
        }
        catch (ClassNotFoundException e) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Il manque le driver MariaDB!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        try {
            MariaDbPoolDataSource dataSource = new MariaDbPoolDataSource("jdbc:mariadb://" + config.getString("database.host") + "/" + config.getString("database.database") + "?user=" + config.getString("database.user") + "&password=" + config.getString("database.password") + "&maxPoolSize=10");
            conn = dataSource.getConnection();
        }
        catch (SQLException e) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Erreur lors de la connexion \u00e0 la base de donn\u00e9es.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        return conn;
    }

    private void updateConfig() {
        this.getLogger().info("V\u00e9rification du fichier de configuration...");
        if (config.contains("msg-server-port")) {
            this.getLogger().info("Mise \u00e0 jour du param\u00e8tre 'internal-webserver-port'");
            if (config.contains("internal-webserver-port")) {
                config.set("internal-webserver-port", (Object)config.getString("msg-server-port"));
                config.set("msg-server-port", null);
            } else {
                config.addDefault("internal-webserver-port", (Object)25566);
            }
            config.options().copyDefaults(true);
            this.saveConfig();
            this.reloadConfig();
        }
    }

    private void initDatabase() {
        try {
            Connection con = this.bddOpenConn();
            PreparedStatement ps = con.prepareStatement("CREATE TABLE IF NOT EXISTS `site_userSetting` (\n  `uuid` varchar(36) NOT NULL DEFAULT '',\n  `name` varchar(128) NOT NULL,\n  `value` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n  PRIMARY KEY (`uuid`,`name`) USING BTREE\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
            ps.executeQuery();
            ps = con.prepareStatement("CREATE TABLE IF NOT EXISTS `site_linkCode` (\n `uuid` VARCHAR(36) NOT NULL,\n `code` VARCHAR(8) NOT NULL,\n `time` TIMESTAMP NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),\n `used` BOOLEAN,\n PRIMARY KEY (`uuid`),\n UNIQUE INDEX `code` (`code`)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
            ps.executeQuery();
            con.close();
        }
        catch (Exception e) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Erreur lors de l'ex\u00e9cution de initDatabase(): " + e);
        }
    }
}

