/*
 * Decompiled with CFR 0.152.
 */
package com.slprojects.slcraftplugin.tachesParalleles;

import com.slprojects.slcraftplugin.Main;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class savePlayerData {
    private final Main plugin;
    private Connection con;
    private final List<UUID> playTimeUsersIndexes;
    private final List<LocalDateTime> playTimeUsersDate;

    public savePlayerData(Main plugin) {
        this.plugin = plugin;
        this.playTimeUsersIndexes = new ArrayList<UUID>();
        this.playTimeUsersDate = new ArrayList<LocalDateTime>();
    }

    public void saveOnJoin(Player player) {
        this.con = this.plugin.bddOpenConn();
        this.playTimeUsersIndexes.add(player.getUniqueId());
        this.playTimeUsersDate.add(LocalDateTime.now());
        this.insertPlayerName(player);
        this.playerAddPlayerEntryOrExit(player, true);
        this.checkJoinedDate(player);
        this.setPlayerJoinCount(player);
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Impossible de fermer la connexion \u00e0 la bdd. Func savePlayerData::saveOnJoin(Player player)");
            e.printStackTrace();
        }
    }

    public void saveOnQuit(Player player) {
        this.con = this.plugin.bddOpenConn();
        this.calculatePlayerPlayTime(player);
        this.playerAddPlayerEntryOrExit(player, false);
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Impossible de fermer la connexion \u00e0 la bdd. Func savePlayerData::saveOnQuit(Player player)");
            e.printStackTrace();
        }
    }

    private void insertPlayerName(Player player) {
        try {
            PreparedStatement rechercheUtilisateur = this.con.prepareStatement("SELECT * FROM site_userSetting WHERE uuid = ? AND name = 'playerName' AND value = ?");
            rechercheUtilisateur.setString(1, player.getUniqueId().toString());
            rechercheUtilisateur.setString(2, player.getName());
            ResultSet resultat = rechercheUtilisateur.executeQuery();
            if (resultat.next()) {
                if (!resultat.getString("value").equals(player.getName())) {
                    PreparedStatement updateUtilisateur = this.con.prepareStatement("UPDATE site_userSetting SET value = ? WHERE uuid = ? AND name = 'playerName'");
                    updateUtilisateur.setString(1, player.getName());
                    updateUtilisateur.setString(2, player.getUniqueId().toString());
                    updateUtilisateur.executeUpdate();
                }
            } else {
                PreparedStatement insertUtilisateur = this.con.prepareStatement("INSERT INTO site_userSetting (uuid, name, value) VALUES (?, 'playerName', ?)");
                insertUtilisateur.setString(1, player.getUniqueId().toString());
                insertUtilisateur.setString(2, player.getName());
                insertUtilisateur.executeQuery();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Func savePlayerData::insertPlayerName(Player player)");
            e.printStackTrace();
        }
    }

    private void playerAddPlayerEntryOrExit(Player player, boolean isEnter) {
        try {
            PreparedStatement insertPlayerEntryOrExit = this.con.prepareStatement("INSERT INTO site_playerEntries (uuid, isJoin, date) VALUES (?, ?, ?)");
            insertPlayerEntryOrExit.setString(1, player.getUniqueId().toString());
            insertPlayerEntryOrExit.setBoolean(2, isEnter);
            insertPlayerEntryOrExit.setString(3, Timestamp.valueOf(LocalDateTime.now()).toString());
            insertPlayerEntryOrExit.executeQuery();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Func savePlayerData::playerAddPlayerEntryOrExit(Player player, boolean isEnter)");
            e.printStackTrace();
        }
    }

    private void checkJoinedDate(Player player) {
        try {
            PreparedStatement rechercheUtilisateur = this.con.prepareStatement("SELECT * FROM site_userSetting WHERE uuid = ? AND name = 'joinedDate'");
            rechercheUtilisateur.setString(1, player.getUniqueId().toString());
            ResultSet resultat = rechercheUtilisateur.executeQuery();
            if (!resultat.next()) {
                if (player.hasPlayedBefore()) {
                    PreparedStatement rechercheDateInscription = this.con.prepareStatement("SELECT time FROM co_user WHERE uuid = ?");
                    rechercheDateInscription.setString(1, player.getUniqueId().toString());
                    resultat = rechercheDateInscription.executeQuery();
                    if (resultat.next()) {
                        PreparedStatement insertionDateInscription = this.con.prepareStatement("INSERT INTO site_userSetting (`uuid`, `name`, `value`) VALUES (?,'joinedDate',?)");
                        insertionDateInscription.setString(1, player.getUniqueId().toString());
                        insertionDateInscription.setString(2, Timestamp.valueOf(LocalDateTime.ofEpochSecond(Long.parseLong(resultat.getString("time")), 0, ZoneOffset.UTC)).toString());
                        insertionDateInscription.executeQuery();
                        this.plugin.getLogger().info("Le joueur " + ChatColor.GOLD + player.getName() + ChatColor.RESET + " n'avait pas de donn\u00e9es sur sa date d'inscription dans dans la table des param\u00e8tres utilisateurs. On lui a donc attribu\u00e9 comme date de cr\u00e9ation du compte, celle que d\u00e9tenait CoreProtect.");
                    } else {
                        PreparedStatement insertionDateInscription = this.con.prepareStatement("INSERT INTO site_userSetting (`uuid`, `name`, `value`) VALUES (?,'joinedDate',?)");
                        insertionDateInscription.setString(1, player.getUniqueId().toString());
                        insertionDateInscription.setString(2, Timestamp.valueOf(LocalDateTime.now()).toString());
                        insertionDateInscription.executeQuery();
                        PreparedStatement insertionInaccurrateJoinedDate = this.con.prepareStatement("INSERT INTO site_userSetting (`uuid`, `name`, `value`) VALUES (?,'inaccurrateJoinedDate',?)");
                        insertionInaccurrateJoinedDate.setString(1, player.getUniqueId().toString());
                        insertionInaccurrateJoinedDate.setString(2, "true");
                        insertionInaccurrateJoinedDate.executeQuery();
                        this.plugin.getLogger().info("Le joueur " + ChatColor.GOLD + player.getName() + ChatColor.RESET + " n'avait pas de donn\u00e9es sur sa date d'inscription dans dans la table des param\u00e8tres utilisateurs, ni dans la table des utilisateurs de CoreProtect. On lui a donc attribu\u00e9 comme date de cr\u00e9ation du compte, la date du d\u00e9but de sa partie.");
                    }
                } else {
                    PreparedStatement insertionDateInscription = this.con.prepareStatement("INSERT INTO site_userSetting (`uuid`, `name`, `value`) VALUES (?,'joinedDate',?)");
                    insertionDateInscription.setString(1, player.getUniqueId().toString());
                    insertionDateInscription.setString(2, Timestamp.valueOf(LocalDateTime.now()).toString());
                    insertionDateInscription.executeQuery();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Func savePlayerData::checkJoinedDate(Player player)");
            e.printStackTrace();
        }
    }

    void setPlayerJoinCount(Player player) {
        try {
            PreparedStatement rechercheJoinCount = this.con.prepareStatement("SELECT * FROM site_userSetting WHERE uuid = ? AND name = 'joins'");
            rechercheJoinCount.setString(1, player.getUniqueId().toString());
            ResultSet resultat = rechercheJoinCount.executeQuery();
            if (resultat.next()) {
                PreparedStatement updateJoinCount = this.con.prepareStatement("UPDATE site_userSetting SET value = ? WHERE uuid = ? AND name = 'joins'");
                updateJoinCount.setString(1, String.valueOf(player.getStatistic(Statistic.LEAVE_GAME) + 1));
                updateJoinCount.setString(2, player.getUniqueId().toString());
                updateJoinCount.executeQuery();
            } else {
                PreparedStatement insertionJoinCount = this.con.prepareStatement("INSERT INTO site_userSetting (`uuid`, `name`, `value`) VALUES (?,'joins',?)");
                insertionJoinCount.setString(1, player.getUniqueId().toString());
                insertionJoinCount.setString(2, String.valueOf(player.getStatistic(Statistic.LEAVE_GAME) + 1));
                insertionJoinCount.executeQuery();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Func savePlayerData::setPlayerJoinCount(Player player)");
            e.printStackTrace();
        }
    }

    private void calculatePlayerPlayTime(Player player) {
        LocalDateTime timeNow = LocalDateTime.now();
        Duration duration = Duration.between(timeNow, this.playTimeUsersDate.get(this.playTimeUsersIndexes.indexOf(player.getUniqueId())));
        long playedTimeInSeconds = Math.abs(duration.toSeconds());
        try {
            PreparedStatement recherchePlayTime = this.con.prepareStatement("SELECT * FROM site_userSetting WHERE uuid = ? AND name = 'playedTime'");
            recherchePlayTime.setString(1, player.getUniqueId().toString());
            ResultSet resultat = recherchePlayTime.executeQuery();
            if (resultat.next()) {
                PreparedStatement updatePlayTime = this.con.prepareStatement("UPDATE site_userSetting SET value = ? WHERE uuid = ? AND name = 'playedTime'");
                updatePlayTime.setString(1, String.valueOf(Long.parseLong(resultat.getString("value")) + playedTimeInSeconds));
                updatePlayTime.setString(2, player.getUniqueId().toString());
                updatePlayTime.executeQuery();
            } else {
                PreparedStatement insertionPlayTime = this.con.prepareStatement("INSERT INTO site_userSetting (`uuid`, `name`, `value`) VALUES (?,'playedTime',?)");
                insertionPlayTime.setString(1, player.getUniqueId().toString());
                insertionPlayTime.setString(2, String.valueOf(playedTimeInSeconds));
                insertionPlayTime.executeQuery();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning(ChatColor.RED + "Func savePlayerData::increasePlayerPlayTime(Player player)");
            e.printStackTrace();
        }
    }
}

